﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public static class InputEdipiOrIcnCreator
    {
        /// <summary>
        /// Create a InputEdipiIcn which then can be used to create an inputEdiPiOrIcn class which is used
        /// to create a getDeploymentRequest.
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public static InputEdipiIcn CreateUppercasedEdipi(string edipi)
        {
            var inputEdipi = new InputEdipiIcn();
            inputEdipi.edipiORicnValue = edipi;
            inputEdipi.inputType = InputEdipiIcnInputType.EDIPI;
            return inputEdipi;
        }
        /// <summary>
        /// You need to add an InputEdipiIcn to create a different class inputEdiPiOrIcn class that is used to create 
        /// a Request
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public static inputEdiPiOrIcn Create(string edipi)
        {
            InputEdipiIcn upperCasedEdipi = CreateUppercasedEdipi(edipi);
            var input = new inputEdiPiOrIcn();
            input.edipiORicn = upperCasedEdipi;
            return input;
        }
    }
}
